/*
*******************************************************************************
*
* File:         xmutex.h
* Description:  
* Author:       Henrik Liebau
* Created:      10 Apr 2000, 13:38:54
* Modified:     Wed Apr 12 13:22:50 2000 by Henrik Liebau, BVS R&D
* Language:     C/C++ Include File
* Package:      Agilent E2929 CAPI
* Status:       
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/

#ifndef __xmutex_H__
#define __xmutex_H__

/* include type definitions */
#ifndef __xmutxdef_H__
#include <xmutxdef.h>
#endif

/*/////////////////////////////////////////////////////////////////////////////
// global synchronization stuff
/////////////////////////////////////////////////////////////////////////////*/

/*****************************************************************************
 * Mutexes
 *****************************************************************************/

/* create mutex */
bx_errtype EXPORT BestXCreateMutex (bx_mutextype * theMutex);

/* delete mutex */
bx_errtype EXPORT BestXDeleteMutex (bx_mutextype * theMutex);

/* lock mutex, block if not available !!!careful with this! */
bx_errtype EXPORT BestXLockMutex (bx_mutextype theMutex);

/* unlock mutex */
bx_errtype EXPORT BestXUnlockMutex (bx_mutextype theMutex);

/*****************************************************************************
 * Critical Section
 *****************************************************************************/

bx_errtype EXPORT BestXCreateCriticalSection (bx_critsecttype * theCritSect);
bx_errtype EXPORT BestXDeleteCriticalSection (bx_critsecttype * theCritSect);

bx_errtype EXPORT BestXEnterCriticalSection (bx_critsecttype * theCritSect);
bx_errtype EXPORT BestXLeaveCriticalSection (bx_critsecttype * theCritSect);

/* -------- Do not add code below this line -------- */
#endif /* defined xmutex_H__ */
